/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.pssim;

import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.VWTimerLog;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.server.VWCapsule;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.listener.axis.AxisFactorySettings;
import filenet.ws.listener.utils.AxisHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;

public class InvokePSSimHelper {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.pssim");
    protected static final String m_className = "InvokePSSimHelper";
    protected static final String UPDATE_DOC_REQUEST = "updateDocRequest";
    protected static final String NAME = "name";
    protected static final String SESS = "sess";
    protected static final String NOENC = "noenc";
    protected static final String DOC_ID = "docId";

    public static String _get_FILE_DATE() {
        return "$Date:   06 Aug 2008 15:00:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.9  $";
    }

    public static int getWSTimeout() {
        int wsTimeout = 300000;
        try {
            wsTimeout = Integer.parseInt(System.getProperty("synchronous.timeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wsTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSimData(String soapAddress, String docId, String user, String pw, boolean noEnc, String[] filenames, String[] mimeTypes) throws Exception {
        String m_method = "updateSimData";
        if (filenames == null) {
            return;
        }
        int nDocs = filenames.length;
        if (logger.isFinest()) {
            logger.finest(m_className, "updateSimData", soapAddress + "," + docId + Logger.asString(filenames));
        }
        VWTimerLog timer = null;
        AxisFactorySettings soapFactorySettings = new AxisFactorySettings();
        try {
            if (logger.isFinest()) {
                logger.finest(m_className, "updateSimData", "soapAddress=" + soapAddress);
            }
            String sEnv = "s:Envelope";
            String sBody = "s:Body";
            String sHeader = "<s:Header/>";
            StringBuffer buf = new StringBuffer();
            buf.append("<?xml version='1.0' encoding='UTF-8'?><").append("s:Envelope").append(" xmlns:s=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">").append("<s:Header/>").append("<").append("s:Body").append(">");
            buf.append("<").append(UPDATE_DOC_REQUEST).append(">").append("<").append(NAME).append(">").append(XMLHelper.toXMLString(user)).append("</").append(NAME).append(">").append("<").append(SESS).append(">").append(XMLHelper.toXMLString(pw)).append("</").append(SESS).append(">").append("<").append(DOC_ID).append(">").append(XMLHelper.toXMLString(docId)).append("</").append(DOC_ID).append(">");
            if (noEnc) {
                buf.append("<").append(NOENC).append("/>");
            }
            long size = 0L;
            for (int i = 0; i < nDocs; ++i) {
                File f = new File(filenames[i]);
                buf.append("<file").append(i).append(">").append(XMLHelper.toXMLString(f.getName())).append("</file").append(i).append(">");
                size += f.length();
            }
            buf.append("</").append(UPDATE_DOC_REQUEST).append(">");
            buf.append("</").append("s:Body").append("></").append("s:Envelope").append(">");
            if (logger.isFinest()) {
                logger.finest(m_className, "updateSimData", "SOAPMessage=" + buf.toString());
            }
            timer = new VWTimerLog("Document.updateSimData size=" + Long.toString(size));
            SOAPConnectionFactory scFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = scFactory.createConnection();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(buf.toString().getBytes("UTF-8")));
            message.getMimeHeaders().addHeader("SOAPAction", "");
            for (int i = 0; i < nDocs; ++i) {
                try {
                    if (logger.isFinest()) {
                        logger.finest(m_className, "updateSimData", "attaching: " + filenames[i] + ", " + mimeTypes[i]);
                    }
                    AttachmentPart attach = message.createAttachmentPart();
                    attach.setContent((Object)new FileInputStream(filenames[i]), mimeTypes[i]);
                    message.addAttachmentPart(attach);
                    continue;
                }
                catch (Exception e) {
                    logger.throwing(m_className, "updateSimData", e);
                    throw e;
                }
            }
            int wsTimeout = InvokePSSimHelper.getWSTimeout();
            SOAPMessage response = AxisHelper.callEx(connection, message, soapAddress, wsTimeout, false);
            SOAPBody responseBody = response.getSOAPPart().getEnvelope().getBody();
            if (logger.isFinest()) {
                logger.finest(m_className, "updateSimData", "responseBody.toString=" + responseBody.toString());
            }
            if (responseBody.hasFault()) {
                SOAPFault soapFault = responseBody.getFault();
                logger.warning(m_className, "updateSimData", "Response Has FAULT: " + soapFault.toString());
                throw new Exception(soapFault.toString());
            }
        }
        finally {
            logger.exiting(m_className, "updateSimData");
            soapFactorySettings.reset();
            if (timer != null) {
                timer.stop();
            }
        }
    }

    private static void checkArg(String sArg) throws Exception {
        if (sArg == null || sArg.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!new File(sArg).exists()) {
            throw new FileNotFoundException(sArg);
        }
    }

    private static String[] getFiles(VWCommandLineArgs vwArgs) throws Exception {
        int m_nFiles = vwArgs.getIntParameter("nFiles", 0);
        if (m_nFiles == 0) {
            throw new Exception("No Files!");
        }
        String[] m_sFiles = new String[m_nFiles];
        for (int i = 0; i < m_nFiles; ++i) {
            m_sFiles[i] = vwArgs.getParameter("File" + Integer.toString(i));
            InvokePSSimHelper.checkArg(m_sFiles[i]);
        }
        return m_sFiles;
    }

    private static String[] getMimeTypes(VWCommandLineArgs vwArgs) throws Exception {
        int m_nFiles = vwArgs.getIntParameter("nFiles", 0);
        if (m_nFiles == 0) {
            throw new Exception("No Files!");
        }
        String[] m_sFiles = new String[m_nFiles];
        for (int i = 0; i < m_nFiles; ++i) {
            m_sFiles[i] = vwArgs.getParameter("MimeType" + Integer.toString(i));
        }
        return m_sFiles;
    }

    private static void printUsage() {
        System.out.println("Usage:  /soapAddress <soapAddess> /name <user> /pw <pw> /WcmApiConfig.properties <WcmApiConfig.properties filepath> [/noenc] ");
        System.out.println("soapAddress example:  http://localhost:8080/Workplace/P8BPMWSBroker/pssim/");
    }

    public static void main(String[] args) {
        VWCommandLineArgs c = new VWCommandLineArgs(args);
        try {
            String soapAddress = c.getParameter("soapAddress", "http://localhost:8080/Workplace/P8BPMWSBroker/pssim/");
            String user = c.getParameter(NAME, "qdang");
            String pw = c.getParameter("pw", "fn92626");
            boolean noenc = c.isPresent(NOENC);
            if (!noenc) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "main", "orig. user=" + user);
                }
                VWCapsule cap1 = new VWCapsule(user);
                user = cap1.getStr();
                VWCapsule cap2 = new VWCapsule(pw);
                pw = cap2.getStr();
            }
            String[] m_sFiles = InvokePSSimHelper.getFiles(c);
            String[] m_sMimeTypes = InvokePSSimHelper.getMimeTypes(c);
            String docId = c.getParameter(DOC_ID);
            if (docId == null) {
                IVWIDMFactory f = null;
                String wcmApiConfigFile = c.getParameter("WcmApiConfig.properties");
                f = VWIDMBaseFactory.instance(c);
                IVWIDMDialog dlg = f.getBrowseDialog(null, 1, "OK", null);
                dlg.showDialog(null);
                IVWIDMItem doc = dlg.getSelectedItem();
                if (doc != null) {
                    docId = doc.getCanonicalName();
                }
            }
            if (docId == null) {
                System.exit(0);
            }
            System.out.println("Selected " + docId);
            InvokePSSimHelper.updateSimData(soapAddress, docId, user, pw, noenc, m_sFiles, m_sMimeTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

